(function($){
	$.fn.mbSelect = function(opts) {
		var o = $.extend({
			debug: false,
			onchange: function(){}
		}, opts);

		if(o.debug) console.log('[mbSelect] options:', o);

		$(this).each(function(){
			var $t = $(this);

			// whole wrap
			// $t.siblings('label').andSelf().wrapAll('<div class="fake-select" />');

			if($t.parent('.mb-select-wrap').size())
				return false;

			if(o.debug) console.log('[mbSelect] attached to:', $t);

			$t.wrap('<div class="mb-select-wrap" />');
			$t.after('<div class="mb-value" />');

			$t.next('.mb-value').text($t.find(':selected').text());

			// initial
			o.onchange($t, $t.find(':selected').val(), $t.find(':selected').text());

			$t.change(function(){
				$t.next('.mb-value').text($t.find(':selected').text());
				o.onchange($t, $t.find(':selected').val(), $t.find(':selected').text());
			});
		});

		return this;
	}	
})(jQuery)
