
function initialize() {

    var image = '/sites/all/themes/artefakt/images/mapmarker.png'; // marker
    var centerLatlng = new google.maps.LatLng(51.304480, 17.066767); // centrowanie
    var myLatlng = new google.maps.LatLng(51.302096, 17.077537); // punkt na mapie
    var biuroPSG = new google.maps.LatLng(51.306927, 17.060409); // kolejny punkt na mapie

    var styles = [
	{
	    stylers: [
		{saturation: '0'},
		{visibility: 'simplified'},
		{gamma: 0.7},
		{weight: 1}
	    ]
	},
	{
	    elementType: 'labels',
	    stylers: [
		{visibility: 'on'}
	    ]
	},
//	{
//	    featureType: 'water',
//	    stylers: [
//		{color: '#666666'}
//	    ]
//	},
	{
	    featureType: "road",
	    elementType: "geometry",
	    stylers: [
		{lightness: 100},
		//{ visibility: "simplified" }
		{visibility: "on"}
	    ]
	}, {
	    featureType: "road",
	    elementType: "labels",
	    stylers: [
		{visibility: "on"}
	    ]
	}
    ];


    // Create a new StyledMapType object, passing it the array of styles,
    // as well as the name to be displayed on the map type control.
    var styledMap = new google.maps.StyledMapType(styles,
	    {name: "Styled Map"});
    //Parametry mapy
    var mapOptions = {
	zoom: 14,
	center: centerLatlng,
	panControl: false,
	zoomControl: false,
	mapTypeControl: false,
	scaleControl: true,
	streetViewControl: false,
	overviewMapControl: false,
	mapTypeControlOptions: {
	    mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'map_style']
	}

    };
    
    // ustawienie mapy w domie i nadanie wygladu z tabeli asocjacyjnej
    var map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
    //Associate the styled map with the MapTypeId and set it to display.
    map.mapTypes.set('map_style', styledMap);
    map.setMapTypeId('map_style');
    
    
    // zdefiniowanie tresci blokow informacyjnych
    var blokInformacyjny1 = '<div id="content">' +
	    '<div id="siteNotice">' +
	    '</div>' +
	    '<h1 id="firstHeading" class="firstHeading">Bukowe Osiedle</h1>' +
	    '</div>' +
	    '</div>';
    var blokInformacyjny2 = '<div id="content">' +
	    '<div id="siteNotice">' +
	    '</div>' +
	    '<h1 id="firstHeading" class="firstHeading">Biuro sprzedaży mieszkań</h1>' +
	    '<div id="bodyContent">' +
	    '<p>ul. Obrońców Pokoju 43 lok. 3<br>55-100 Trzebnica' +
	    '</div>' +
	    '</div>';
    // stworzenie blokow i przypisanie do nich informacji powyzej
    var infowindow = new google.maps.InfoWindow({
	content: blokInformacyjny1
    });
    var infowindow2 = new google.maps.InfoWindow({
	content: blokInformacyjny2
    });
    

    //markery na mapie
    var marker = new google.maps.Marker({
	position: myLatlng,
	map: map,
	title: "Bukowe osiedle",
	icon: image
    });
    var marker2 = new google.maps.Marker({
	position: biuroPSG,
	map: map,
	title: "Biuro PSG",
	icon: image
    });
    // dodanie clicka dla obu markerow
    google.maps.event.addListener(marker, 'click', function() {
	infowindow.open(map, marker);
    });

    google.maps.event.addListener(marker2, 'click', function() {
	infowindow2.open(map, marker2);
    });

}

google.maps.event.addDomListener(window, 'load', initialize);













